# Testing Guide - The Soul Cats Band Website

## How to Test the Website

### 1. **Opening the Website**
- Open `index.html` in your web browser
- Or use a local server (if available)

### 2. **Navigation Testing**

**Desktop (1024px+):**
- [ ] All navigation links visible in horizontal menu
- [ ] Links highlight on hover
- [ ] Current page shows as active (underline)
- [ ] No hamburger menu visible

**Tablet (411-1023px):**
- [ ] Menu is visible but might be adjusted
- [ ] Navigation links are accessible
- [ ] Proper spacing maintained

**Mobile (≤410px):**
- [ ] Hamburger menu (☰) icon visible
- [ ] Click menu icon to show/hide navigation
- [ ] Navigation appears as vertical list
- [ ] Menu closes when link is clicked
- [ ] Active page indicator still works

### 3. **Page Testing**

#### Home Page (index.html)
- [ ] Hero section displays with title and subtitle
- [ ] "Book Us Today" button is clickable and leads to Contact page
- [ ] Event types section shows all 6 event types
- [ ] Benefits section displays 3 columns on desktop
- [ ] Footer displays correctly with links
- [ ] Phone: (555) 123-4567 visible

#### About Us (About us.html)
- [ ] Band story section displays with text and stats box
- [ ] All 6 band member cards display with:
  - [ ] Profile photo
  - [ ] Name and role
  - [ ] Bio text
- [ ] Cards have hover effect (lift up and shadow)
- [ ] Philosophy section shows 4 values
- [ ] "Book A Performance" button works

#### Song Samples (Song Samples.html)
- [ ] All 8 video embeds display
- [ ] Videos maintain aspect ratio
- [ ] Setlist section shows songs in 2 columns
- [ ] Videos can be played directly

#### Contact Us (Contact.html)
- [ ] Two-column layout on desktop
- [ ] Contact form displays on left
- [ ] Contact info and map on right

**Form Testing:**
- [ ] First Name field required
  - [ ] Shows red asterisk (*)
  - [ ] Different border styling
- [ ] Last Name field required
  - [ ] Shows red asterisk (*)
  - [ ] Different border styling
- [ ] Email field required
  - [ ] Shows red asterisk (*)
  - [ ] Different border styling
  - [ ] Input type="email"
- [ ] Phone (optional)
  - [ ] No asterisk
  - [ ] Input type="tel"
- [ ] Event Date (optional)
  - [ ] No asterisk
  - [ ] Input type="date"
- [ ] Event Type (optional dropdown)
  - [ ] No asterisk
  - [ ] Options: Wedding, Corporate, Party, Winery, Other
- [ ] Message (optional)
  - [ ] Textarea element
  - [ ] No asterisk
- [ ] Submit button
  - [ ] Shows success message with name and email
  - [ ] Form resets after submission
  - [ ] Validates required fields

**Contact Info Testing:**
- [ ] Phone number (555) 123-4567 is clickable (tel: link)
- [ ] Email address is clickable (mailto: link)
- [ ] Google Map embed displays
- [ ] Social media Facebook link works and opens in new tab
- [ ] All contact details visible

### 4. **Responsive Design Testing**

Using browser developer tools (F12):

**1024px and up (Desktop):**
- [ ] 3-column grid layouts render properly
- [ ] Full navigation menu visible
- [ ] Two-column contact layout works
- [ ] Video grid shows multiple columns
- [ ] No hamburger menu

**411px - 1023px (Tablet):**
- [ ] Layouts adjust appropriately
- [ ] 3-column grids become 2-column
- [ ] Spacing scales correctly
- [ ] Content remains readable
- [ ] No hamburger menu yet

**410px and below (Mobile):**
- [ ] Hamburger menu visible and functional
- [ ] All grids become single-column
- [ ] Text sizes are readable
- [ ] Buttons are touch-friendly
- [ ] Forms are easy to fill
- [ ] Images scale properly
- [ ] Footer is accessible

### 5. **Visual Design Testing**

- [ ] Colors are consistent
- [ ] Gold accent (#d4a574) used throughout
- [ ] Dark background (#1a1a1a) for headers/footer
- [ ] Proper contrast for readability
- [ ] Fonts are readable (Playfair Display & Lato)
- [ ] Spacing is consistent
- [ ] No overlapping elements

### 6. **Interaction Testing**

- [ ] Links have hover color change
- [ ] Buttons show hover effect (color change + shadow)
- [ ] Cards lift on hover
- [ ] Form inputs highlight on focus
- [ ] All transitions are smooth
- [ ] No jumpy animations

### 7. **Browser Testing**

Test in multiple browsers:
- [ ] Chrome
- [ ] Firefox
- [ ] Safari
- [ ] Edge

### 8. **Favicon Testing**

- [ ] Favicon appears in browser tab
- [ ] Favicon shows musical notes
- [ ] Appears on all pages

### 9. **CSS Features Testing**

- [ ] Verify CSS Grid used (.grid-2, .grid-3, etc.)
- [ ] Verify Flexbox used (navigation, cards, etc.)
- [ ] Transitions are smooth (0.3s ease-in-out)
- [ ] CSS Reset applied (no default margins/padding)
- [ ] CSS custom properties used (colors, spacing)

### 10. **Content Testing**

- [ ] All band member names correct
- [ ] All roles accurately listed
- [ ] Event descriptions match requirements
- [ ] Social links correct
- [ ] No broken links
- [ ] All images load properly

### 11. **Accessibility Testing**

- [ ] Can tab through all interactive elements
- [ ] Form labels properly associated
- [ ] Images have alt text where needed
- [ ] Heading hierarchy is proper (h1 → h2 → h3)
- [ ] Color contrast is readable
- [ ] Mobile menu is keyboard accessible

## Common Issues & Solutions

### Navigation Menu Issues
- If menu doesn't toggle on mobile, check browser console for JavaScript errors
- Ensure JavaScript is enabled

### Responsive Layout Issues
- Clear browser cache (Ctrl+Shift+Delete)
- Test in private/incognito window
- Check that viewport meta tag is present in HTML

### Video Issues
- Check internet connection (videos are embedded)
- Ensure YouTube isn't blocked
- Try different browser if one fails

### Form Issues
- Ensure required fields are filled before submit
- Check email format is valid (email@example.com)
- Browser should show validation errors

## Quick Checklist

- [ ] All 4 pages open and display correctly
- [ ] Navigation works on all breakpoints
- [ ] Responsive design works (desktop, tablet, mobile)
- [ ] Contact form validates properly
- [ ] Google Maps displays
- [ ] All links work
- [ ] Favicon appears
- [ ] No console errors
- [ ] CSS transitions are smooth
- [ ] Mobile menu functions

## Validation Resources

To validate your code:

1. **HTML Validation:**
   - Visit: https://validator.w3.org/
   - Upload your HTML files
   - Check for errors

2. **CSS Validation:**
   - Visit: https://jigsaw.w3.org/css-validator/
   - Upload your CSS file
   - Check for errors

---

**Note:** CSS linter may show false positives for CSS custom properties in inline styles - these are valid CSS and will work in all modern browsers.
